# -*- coding: utf-8 -*-

#########E  CAPACITE NUMERIQUE N°3

''' 
Résolution numérique d'une équation différentielle d'ordre 1 avec la fonction odeint de python 
(scipy). Ici, on utilise un circuit RC classique. 
 Mettre en oeuvre odeint pour simuler la réponse d'un système linéaire du premier ordre à un échelon de tension
 du/dt + u/tau = E/tau avec tau = RC
'''


## Circuit RC soumis à un échelon de tension

# Importation des bibliothèques utiles
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import odeint
#from scipy.optimize import bisect

# Données R en Ohm, C en Farad, ces valeurs sont modifiables
R = 10*1E3
C = 1*1E-6

tau = R*C

# Données E en V, cette valeur est modifiable
# E différent de 0 pour la charge, E = 0 pour la décharge
E = 12

# tension initiale aux bornes de C en V, cette valeur est modifiable
# u0 = 0 pour la charge, u0 différent de zéron pour la décharge)
u0 = 0

#création du tableau t
a= 0
b= 5*tau
n = 2000
t=np.linspace(a,b,n+1)          # n intervalles, n+1 valeurs


# Equa diff d'ordre 1
def f(u,t) :
    return (E-u)/(R*C)          # du/dt = f(u, t) =(E-u)/(RC). On cherche la liste u

# Fonction odeint                
u=odeint(f,u0,t)                # attention à l'ordre des arguments (y ordonnée, valeur initiale,x abscisse)

# Affichage de la courbe
plt.plot(t, u) 
plt.title('Ordre 1 odeint')
plt.xlabel('t (en s)')
plt.ylabel('u (en V)')
                                            
plt.grid()
plt.show()